/***************************************************************************/
/*  USART3 driver for the NXP LPC43xx microcontrollers.                   */
/***************************************************************************/
#include "nxp_lpc43xx.h"
#include "uart.h"

const char ascii[] = "0123456789ABCDEF";

void USART3_Init(LONG baudrate)
{
  uint32_t brd = (SystemCoreClock / (baudrate << 4));

    LPC_CCU2->CLK_APB2_USART3_CFG |= 1;                // enable USART3 clock
    while (!(LPC_CCU2->CLK_APB2_USART3_STAT & 1));

    LPC_CCU1->CLK_M4_USART3_CFG   |= 1;                // enable USART3 register interface clock
    while (!(LPC_CCU1->CLK_M4_USART3_STAT & 1));

/**** Init USART3 pins ****/
    LPC_SCU->SFSP2_3 =  (1 << 6) |                     // input buffer enabled
                        (1 << 4) |                     // pull-up disabled
                        (2 << 0) ;                     // pin P2_3 used as U3_TXD

    LPC_SCU->SFSP2_4 =  (1 << 6) |                     // input buffer enabled
                        (1 << 4) |                     // pull-up disabled
                        (2 << 0) ;                     // pin P2_3 used as U3_RXD

    LPC_USART3->LCR    = 0x83;                         // 8 bits, no Parity, 1 Stop bit
    LPC_USART3->DLL = (brd & 0xFF);                    // Set baud rate dividers
    LPC_USART3->DLM = (brd >> 8);                      //
//    LPC_USART3->DLL    = 0x06;            /* 115200 Baudrate @ 12 MHz IRC       */
//    LPC_USART3->DLM    = 0x00;
    LPC_USART3->FDR    = 0xC1;
    LPC_USART3->LCR    = 0x03;                         // DLAB = 0
}

char ua_inchar(void)	                               // look if there is a character available
{
    if (LPC_USART3->LSR & 1)
        return LPC_USART3->RBR & 0x7F;                 // yes, return character from input buffer
    else
        return 0xFF;                                   // no, return -1
}

char ua_getchar(void)                                  // this function waits for a character
{
    while (!(LPC_USART3->LSR & 1));
    return LPC_USART3->RBR & 0x7F;                     // Read character from input buffer
}

void ua_outchar(char c)		
{
    while(!(LPC_USART3->LSR & 0x20));
    LPC_USART3->THR = c;
}

void PrintByte(unsigned char b)
{
    ua_outchar(ascii[b >> 4]);
    ua_outchar(ascii[b & 0x0f]);
}

void PrintWord(unsigned short w)
{
    PrintByte((unsigned char)(w>>8));
    PrintByte((unsigned char)w);
}

//void PrintLong(long l)
//{
//    PrintWord((WORD)(l>>16));
//    PrintWord((WORD)l);
//}

void PrintBDecimal(unsigned char b)
{
  unsigned char p;

    p = ascii[b / 10];
    if (p != '0')
        ua_outchar(p);
    ua_outchar(ascii[b % 10]);
}

void PrintWDecimal(unsigned short w)
{
    ua_outchar(ascii[w / 10000]);
    w %= 10000;
    ua_outchar(ascii[w / 1000]);
    w %= 1000;
    ua_outchar(ascii[w / 100]);
    w %= 100;
    ua_outchar(ascii[w / 10]);
    ua_outchar(ascii[w % 10]);
}

void PrintString(const char *s)
{
    while (*s)
    {
        if (*s == '\n')
            ua_outchar('\r');                          // output a '\r' first
        ua_outchar(*s);
        s++;
    }
}
